IF NOT EXISTS(SELECT * 
              FROM   INFORMATION_SCHEMA.TABLES 
              WHERE  TABLE_NAME = 'INTEGRA_BENNER_DEPARA') 
			  
BEGIN 
	CREATE TABLE [dbo].[INTEGRA_BENNER_DEPARA] 
	  ( 
		 [ID]            [UNIQUEIDENTIFIER] NOT NULL, 
		 [CHAVE_DESTINO] [VARCHAR](60) NOT NULL, 
		 [CHAVE_ORIGEM]  [VARCHAR](60) NOT NULL, 
		 [DT_CADASTRO]   [DATETIME2](7) NOT NULL, 
		 [ID_TOPICO]     [INT] NOT NULL, 
		 CONSTRAINT [PK_INTEGRA_BENNER_DEPARA] PRIMARY KEY CLUSTERED ( [ID] ASC )WITH 
		 (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, 
		 ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY] 
	  ) 
	ON [PRIMARY] 

	ALTER TABLE [dbo].[INTEGRA_BENNER_DEPARA] ADD  DEFAULT (getdate()) FOR [DT_CADASTRO]

	ALTER TABLE [dbo].[INTEGRA_BENNER_DEPARA] ADD  DEFAULT (newid()) FOR [ID]
	
	ALTER TABLE [dbo].[INTEGRA_BENNER_DEPARA] WITH CHECK ADD CONSTRAINT [FK_INTEGRA_BENNER_DEPARA_INTEGRA_BENNER_TOPICO_ID] FOREIGN KEY ([ID_TOPICO]) REFERENCES [dbo].[INTEGRA_BENNER_TOPICO] ([ID]) 
	
	ALTER TABLE [dbo].[INTEGRA_BENNER_DEPARA] CHECK CONSTRAINT [FK_INTEGRA_BENNER_DEPARA_INTEGRA_BENNER_TOPICO_ID]
	
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('1¦ ALTO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('1ª AVENIDA', 'Avenida', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('1ª LADEIRA', 'Ladeira', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('1ª PARALELA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('1ª RUA', 'Rua', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('1ª SUBIDA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('1ª TRAVESSA', 'Travessa', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('1ª TRAVESSA DA RODOVIA', 'Travessa', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('1ª VILA', 'Via', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('1º ALTO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('1º BECO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('10ª RUA', 'Rua', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('10ª TRAVESSA', 'Travessa', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('11ª RUA', 'Rua', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('11ª TRAVESSA', 'Travessa', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('12ª RUA', 'Rua', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('12ª TRAVESSA', 'Travessa', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('13ª TRAVESSA', 'Travessa', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('14ª TRAVESSA', 'Travessa', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('15ª TRAVESSA', 'Travessa', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('16ª TRAVESSA', 'Travessa', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('17ª TRAVESSA', 'Travessa', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('18ª TRAVESSA', 'Travessa', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('19ª TRAVESSA', 'Travessa', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('2ª AVENIDA', 'Avenida', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('2ª LADEIRA', 'Ladeira', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('2ª PARALELA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('2ª RUA', 'Rua', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('2ª SUBIDA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('2ª TRAVESSA', 'Travessa', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('2ª TRAVESSA DA RODOVIA', 'Travessa', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('2ª VILA', 'Vila', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('2¬ AVENIDA', 'Avenida', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('2º ALTO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('2º BECO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('20ª TRAVESSA', 'Travessa', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('21ª TRAVESSA', 'Travessa', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('22ª TRAVESSA', 'Travessa', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('3ª AVENIDA', 'Avenida', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('3ª LADEIRA', 'Ladeira', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('3ª PARALELA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('3ª RUA', 'Rua', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('3ª SUBIDA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('3ª TRAVESSA', 'Travessa', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('3ª VILA', 'Vila', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('3º ALTO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('3º BECO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('4ª AVENIDA', 'Avenida', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('4ª PARALELA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('4ª RUA', 'Rua', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('4ª SUBIDA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('4ª TRAVESSA', 'Travessa', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('4ª VILA', 'Vila', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('5ª AVENIDA', 'Avenida', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('5ª RUA', 'Rua', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('5ª SUBIDA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('5ª TRAVESSA', 'Travessa', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('5ª VILA', 'Vila', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('6ª AVENIDA', 'Avenida', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('6ª RUA', 'Rua', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('6ª SUBIDA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('6ª TRAVESSA', 'Travessa', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('7ª RUA', 'Rua', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('7ª TRAVESSA', 'Travessa', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('8ª TRAVESSA', 'Travessa', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('9ª RUA', 'Rua', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('9ª TRAVESSA', 'Travessa', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ACAMPAMENTO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ACESSO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ACESSO LOCAL', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ADRO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('AEROPORTO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ALAMEDA', 'Alameda', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ALTO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ANEL VIÁRIO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ANTIGA ESTAÇÃO', 'Estação', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ANTIGA ESTRADA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('AREA', 'Área', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ÁREA', 'Área', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ÁREA ESPECIAL', 'Área', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('AREA VERDE', 'Área', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ARTÉRIA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ATALHO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('AV', 'Avenida', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('AVENIDA', 'Avenida', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('AVENIDA CONTORNO', 'Avenida', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('AVENIDA MARGINA', 'Avenida', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('AVENIDA MARGINAL', 'Avenida', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('AVENIDA MARGINAL DIREITA', 'Avenida', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('AVENIDA MARGINAL ESQUERDA', 'Avenida', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('AVENIDA PERIMETRAL', 'Avenida', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('BAIXA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('BALAO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('BECO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('BELVEDERE', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('BLOCO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('BLOCOS', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('BOSQUE', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('BOULEVARD', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('BULEVAR', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('BURACO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('CAIS', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('CALCADA', 'Calçada', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('CALÇADA', 'Calçada', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('CALÇADÃO', 'Calçada', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('CAMINHO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('CAMINHO DE SERV', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('CAMINHO DE SERVIDÃO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('CAMPO', 'Campo', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('CAMPUS', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('CANAL', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('CHACARA', 'Chácara', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('CHÁCARA', 'Chácara', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('CHßCARA', 'Chácara', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('CICLOVIA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('CIRCULAR', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('COLONIA', 'Colônia', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('COLÔNIA', 'Colônia', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('COMPLEXO VIARIO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('COMUNIDADE', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('CONDOMFNIO', 'Condomínio', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('CONDOMINIO', 'Condomínio', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('CONDOMÍNIO', 'Condomínio', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('CONDOMINIO RESI', 'Condomínio', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('CONDOMÍNIO RESIDENCIAL', 'Condomínio', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('CONJUNTO', 'Conjunto', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('CONJUNTO HABITA', 'Conjunto', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('CONJUNTO MUTIRÃO', 'Conjunto', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('CONJUNTO RESIDE', 'Conjunto', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('CONJUNTO RESIDENCIAL', 'Conjunto', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('CONTORNO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('CORREDOR', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('CORREGO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('CÓRREGO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('DESCIDA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('DESVIO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('DISTRITO', 'Distrito', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('EIXO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('EIXO INDUSTRIAL', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('EIXO PRINCIPAL', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ELEVADA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ENTRADA PARTICU', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ENTRE QUADRA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ESCADA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ESCADA DE PEDRA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ESCADARIA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ESPLANADA', 'Esplanada', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ESTAÇÃO', 'Estação', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ESTACIONAMENTO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ESTÁDIO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ESTRADA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ESTRADA ANTIGA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ESTRADA DE FERRO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ESTRADA DE LIGA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ESTRADA DE SERV', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ESTRADA ESTADUA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ESTRADA ESTADUAL', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ESTRADA INTERMU', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ESTRADA INTERMUNICIPAL', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ESTRADA MUNICIP', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ESTRADA MUNICIPAL', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ESTRADA NOVA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ESTRADA PARTICU', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ESTRADA VELHA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ESTRADA VICINAL', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ESTßDIO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('FAVELA', 'Favela', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('FAZENDA', 'Fazenda', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('FEIRA', 'Feira', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('FONTE', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('FORTE', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('GALERIA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('GLEBA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('GRANJA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ILHA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('JARDIM', 'Jardim', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('JARDIM RESIDENC', 'Jardim', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('JARDIM RESIDENCIAL', 'Jardim', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('JARDINETE', 'Jardim', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('LADEIRA', 'Ladeira', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('LAGO', 'Lago', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('LAGOA', 'Lagoa', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('LARGO', 'Largo', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('LOTEAMENTO', 'Loteamento', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('MARGEM', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('MARGINAL', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('MERCADO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('MÓDULO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('MONTE', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('MORRO', 'Morro', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('NOVA AVENIDA', 'Avenida', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('NÚCLEO', 'Núcleo', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('NUCLEO HABITACI', 'Núcleo', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('NÚCLEO RURAL', 'Núcleo', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('NULL', 'Núcleo', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('OUTEIRO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('PARADA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('PARALELA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('PARQUE', 'Parque', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('PARQUE MUNICIPA', 'Parque', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('PARQUE MUNICIPAL', 'Parque', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('PARQUE RESIDENC', 'Parque', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('PARQUE RESIDENCIAL', 'Parque', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('PASSAGEM', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('PASSAGEM DE PED', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('PASSAGEM SUBTER', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('PASSARELA', 'Passarela', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('PASSEIO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('PASSEIO PUBLICO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('PATIO', 'Pátio', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('PÁTIO', 'Pátio', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('PONTA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('PONTE', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('PORTO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('PRA?A', 'Praça', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('PRACA', 'Praça', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('PRAÇA', 'Praça', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('PRACA DE ESPORT', 'Praça', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('PRAÇA DE ESPORT', 'Praça', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('PRAIA', 'Praia', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('PROLONGAMENTO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('QUADRA', 'Quadra', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('QUINTA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('R', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('RAMAL', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('RAMPA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('RECANTO', 'Recanto', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('RESIDENCIAL', 'Residencial', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('RETA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('RETIRO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('RETORNO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ROD', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('RODO ANEL', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('RODOVIA', 'Rodovia', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ROTATORIA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ROTATÓRIA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ROTULA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('RÓTULA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('RUA', 'Rua', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('RUA DE LIGACAO', 'Rua', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('RUA DE LIGAÇÃO', 'Rua', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('RUA DE PEDESTRE', 'Rua', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('RUA PARTICULAR', 'Rua', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('RUA PRINCIPAL', 'Rua', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('RUA PROJETADA', 'Rua', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('RUA VELHA', 'Rua', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('RUA VICINAL', 'Rua', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('RUELA', 'Rua', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('SERVIDAO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('SERVIDÃO', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('SERVIDAO DE PAS', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('SERVIDÃO DE PASSAGEM', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('SETOR', 'Setor', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('SÍTIO', 'Sítio', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('SUBIDA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('TERCEIRA AVENID', 'Avenida', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('TERMINAL', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('TRAVESSA', 'Travessa', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('TRAVESSA PARTIC', 'Travessa', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('TRECHO', 'Trecho', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('TREVO', 'Trevo', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('TRINCHEIRA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('TUNEL', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('TÚNEL', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('UNIDADE', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('VALA', 'Outros', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('VALE', 'Vale', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('VEREDA', 'Vereda', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('VIA', 'Via', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('VIA COLETORA', 'Via', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('VIA COSTEIRA', 'Via', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('VIA DE ACESSO', 'Via', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('VIA DE PEDESTRE', 'Via', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('VIA DE PEDESTRES', 'Via', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('VIA EXPRESSA', 'Via', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('VIA LATERAL', 'Via', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('VIA LITORANEA', 'Via', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('VIA LOCAL', 'Via', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('VIA MARGINAL', 'Via', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('VIA PEDESTRE', 'Via', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('VIA PRINCIPAL', 'Via', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('VIADUTO', 'Viaduto', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('VIELA', 'Viela', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('VILA', 'Vila', GETDATE(), 1);
	INSERT INTO INTEGRA_BENNER_DEPARA (CHAVE_ORIGEM, CHAVE_DESTINO, DT_CADASTRO, ID_TOPICO) VALUES('ZIGUE-ZAGUE', 'Outros', GETDATE(), 1);
END